<?php

declare(strict_types=1);

namespace Drupal\recurring_events_registration\Plugin\views\field;

use Drupal\recurring_events_registration\RegistrationCreationService;
use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Field handler to show the type of registration for event series.
 *
 * @ingroup views_field_handlers
 */
#[ViewsField(
  id: "eventseries_registration_type",
)]
class EventSeriesRegistrationType extends FieldPluginBase {

  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected readonly RegistrationCreationService $registrationCreationService,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('recurring_events_registration.creation_service')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // Leave empty to avoid a query on this field.
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $series = $values->_entity;
    $this->registrationCreationService->setEventSeries($series);
    return $this->registrationCreationService->getRegistrationType()->value;
  }

}
