<?php

declare(strict_types=1);

namespace Drupal\Tests\recurring_events_registration\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\recurring_events_registration\NotificationService;

/**
 * Tests the notification service.
 *
 * @coversDefaultClass \Drupal\recurring_events_registration\NotificationService
 * @group recurring_events_registration
 */
class RegistrationNotificationServiceTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'datetime',
    'datetime_range',
    'options',
    'recurring_events',
    'recurring_events_registration',
    'text',
    'user',
  ];

  /**
   * Tests that state does not leak between instances of the service.
   */
  public function testServiceInstantiation(): void {
    $service = $this->getNotificationService();
    $this->assertInstanceOf(NotificationService::class, $service);

    $this->assertFalse($service->getKey(), 'A freshly instantiated service should return FALSE for getKey().');

    $service->setKey('registration_confirmation');
    $this->assertEquals('registration_confirmation', $service->getKey(), 'The key that was set is returned.');

    // Request another instance of the service from the DI container. The state
    // should not leak between instances.
    $newService = $this->getNotificationService();

    $this->assertFalse($newService->getKey(), 'A second instance of the service should also return FALSE for getKey().');
  }

  /**
   * Returns the notification service. This is the system under test.
   *
   * @return \Drupal\recurring_events_registration\NotificationService
   *   The notification service.
   */
  protected function getNotificationService(): NotificationService {
    return $this->container->get('recurring_events_registration.notification_service');
  }

}
