<?php

/**
 * @file
 * Tokens for the recurring_events module.
 */

declare(strict_types=1);

use Drupal\Core\Hook\Attribute\LegacyHook;
use Drupal\Core\Render\BubbleableMetadata;
use Drupal\recurring_events\Hook\RecurringEventsTokensHooks;

/**
 * Implements hook_token_info().
 */
#[LegacyHook]
function recurring_events_token_info() {
  return Drupal::service(RecurringEventsTokensHooks::class)->tokenInfo();
}

/**
 * Implements hook_tokens().
 */
#[LegacyHook]
function recurring_events_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) {
  return Drupal::service(RecurringEventsTokensHooks::class)->tokens($type, $tokens, $data, $options, $bubbleable_metadata);
}
