<?php

/**
 * @file
 * Views functionality for the recurring_events module.
 */

declare(strict_types=1);

use Drupal\Core\Hook\Attribute\LegacyHook;
use Drupal\recurring_events\Hook\RecurringEventsViewsHooks;

/**
 * Implements hook_views_data_alter().
 */
#[LegacyHook]
function recurring_events_views_data_alter(array &$data): void {
  \Drupal::service(RecurringEventsViewsHooks::class)->viewsDataAlter($data);
}
