<?php

declare(strict_types=1);

namespace Drupal\recurring_events\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a EventInstanceCreator attribute object.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class EventInstanceCreator extends Plugin {

  /**
   * Constructs a EventInstanceCreator attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The plugin description.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $description,
    public readonly ?string $deriver = NULL,
  ) {}

}
