<?php

declare(strict_types=1);

namespace Drupal\recurring_events;

use Drupal\Component\Plugin\PluginBase;
use Drupal\recurring_events\Entity\EventSeries;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A base class for EventInstanceCreator plugins.
 *
 * @see \Drupal\recurring_events\Annotation\EventInstanceCreator
 * @see \Drupal\recurring_events\EventInstanceCreatorInterface
 */
abstract class EventInstanceCreatorBase extends PluginBase implements EventInstanceCreatorInterface {

  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected readonly EventCreationService $creationService,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('recurring_events.event_creation_service')
    );
  }

  /**
   * {@inheritDoc}
   */
  public function description() {
    // Retrieve the @description property from the annotation and return it.
    return $this->pluginDefinition['description'];
  }

  /**
   * {@inheritDoc}
   */
  abstract public function processInstances(EventSeries $series);

}
