<?php

declare(strict_types=1);

namespace Drupal\recurring_events;

/**
 * Helper functions to handle the storage.
 */
trait EventInstanceStorageTrait {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The event instance storage.
   *
   * @var \Drupal\recurring_events\EventInstanceStorage
   */
  protected EventInstanceStorage $eventInstanceStorage;

  /**
   * Gets the event instance storage.
   *
   * @return \Drupal\recurring_events\EventInstanceStorage
   *   The event instance storage.
   */
  protected function eventInstanceStorage(): EventInstanceStorage {
    if (!isset($this->eventInstanceStorage)) {
      $this->eventInstanceStorage = $this->entityTypeManager
        ->getStorage('eventinstance');
    }

    return $this->eventInstanceStorage;
  }

}
