<?php

declare(strict_types=1);

namespace Drupal\recurring_events;

/**
 * Helper functions to handle the storage.
 */
trait EventSeriesStorageTrait {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The event series storage.
   *
   * @var \Drupal\recurring_events\EventSeriesStorage
   */
  protected EventSeriesStorage $eventSeriesStorage;

  /**
   * Gets the event series storage.
   *
   * @return \Drupal\recurring_events\EventSeriesStorage
   *   The event series storage.
   */
  protected function eventSeriesStorage(): EventSeriesStorage {
    if (!isset($this->eventInstanceStorage)) {
      $this->eventSeriesStorage = $this->entityTypeManager
        ->getStorage('eventseries');
    }

    return $this->eventSeriesStorage;
  }

}
