<?php

declare(strict_types=1);

namespace Drupal\recurring_events\Plugin\EventInstanceCreator;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\recurring_events\Attribute\EventInstanceCreator;
use Drupal\recurring_events\Entity\EventSeries;
use Drupal\recurring_events\EventInstanceCreatorBase;

/**
 * Plugin that removes and recreates all event instances.
 */
#[EventInstanceCreator(
  id: "recurring_events_eventinstance_recreator",
  description: new TranslatableMarkup("Recreate Event Instances"),
)]
class RecreateEventInstanceCreator extends EventInstanceCreatorBase implements ContainerFactoryPluginInterface {

  /**
   * {@inheritDoc}
   */
  public function processInstances(EventSeries $series) {
    $this->creationService->clearEventInstances($series);
    $this->creationService->createInstances($series);
  }

}
