<?php

namespace Drupal\redirect_audit\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Redirect Audit settings.
 */
class RedirectAuditSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'redirect_audit_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['redirect_audit.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('redirect_audit.settings');

    $form['autofix_enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable automatic fix'),
      '#description' => $this->t('When enabled, automatically fix chains when detected'),
      '#default_value' => $config->get('autofix_enabled'),
    ];

    $form['scan_on_change'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Scan on changes'),
      '#description' => $this->t('Automatically detect changes when redirects are modified'),
      '#default_value' => $config->get('scan_on_change'),
    ];

    $form['batch_size'] = [
      '#type' => 'number',
      '#title' => $this->t('Batch size'),
      '#description' => $this->t('Number of redirects to process per batch'),
      '#default_value' => $config->get('batch_size'),
      '#min' => 1,
      '#max' => 500,
    ];

    $form['max_chain_depth'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum depth'),
      '#description' => $this->t('Maximum depth for chain analysis'),
      '#default_value' => $config->get('max_chain_depth'),
      '#min' => 5,
      '#max' => 50,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('redirect_audit.settings')
      ->set('autofix_enabled', $form_state->getValue('autofix_enabled'))
      ->set('scan_on_change', $form_state->getValue('scan_on_change'))
      ->set('batch_size', $form_state->getValue('batch_size'))
      ->set('max_chain_depth', $form_state->getValue('max_chain_depth'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
