<?php

namespace Drupal\Tests\redirect_audit\Kernel\Service;

use Drupal\Tests\redirect_audit\Kernel\RedirectAuditKernelTestBase;

/**
 * Tests for RedirectAuditStorage service.
 *
 * Essential tests for data persistence.
 *
 * @coversDefaultClass \Drupal\redirect_audit\Service\RedirectAuditStorage
 *
 * @group redirect_audit
 * @codingStandardsIgnoreFile
 */
class RedirectAuditStorageTest extends RedirectAuditKernelTestBase {

  /**
   * Tests storage saves and retrieves chain data.
   */
  public function testSavesAndRetrievesChain(): void {
    // Arrange.
    $source_rid = 1;
    $target_rid = 2;
    $path = '3.4';

    // Act: Save chain.
    $audit_id = $this->storage->saveChain($source_rid, $target_rid, $path);

    // Assert: Can retrieve saved data.
    $this->assertGreaterThan(0, $audit_id);

    $record = $this->storage->getChainById($audit_id);
    $this->assertIsArray($record);
    $this->assertEquals($source_rid, $record['source_rid']);
    $this->assertEquals($target_rid, $record['target_rid']);
    $this->assertEquals($path, $record['path']);
  }

}
