# Introduction

This module analyzes redirect entities to identify:
- **Chain patterns**: Chained redirect sequences (A → B → C → D) that cause unnecessary HTTP redirects
- **Loop patterns**: Circular redirect references (A → B → C → A) that break navigation
- **Performance issues**: Redirect chains impact page load times and SEO rankings

## Features

- **Automated chain detection**
- **Loop detection**
- **Batch-based fixing**
- **Queue-based monitoring**
- **Visual dashboard**

## Requirements

- Redirect module (composer require 'drupal/redirect:^1.0)

## Installation

Install via Composer:

```bash
composer require drupal/redirect_audit
drush en redirect_audit
```

### Database Schema

On installation, the module creates:
- `redirect_audit_chains`: Stores detected chains/loops with source/target redirect IDs and intermediate paths
- `redirect_audit_processed`: Tracks processing status.

## Configuration

Navigate to `/admin/config/search/redirect/audit` or **Configuration → Search and metadata → Redirect → Audit**

## Usage

### Drush Commands

Quick command-line operations:

```bash
# Scan all redirects
drush ras

# Fix detected chains
drush raf

# View detailed information
drush rai
```

#### Command Details

- **`redirect-audit:scan` (ras)**: Analyzes all redirects and detects chains/loops
- **`redirect-audit:fix` (raf)**: Automatically fixes redirect chains
- **`redirect-audit:info` (rai)**: Displays statistics, configuration, and detailed records

### Administrative Interface

Dashboard at `/admin/config/search/redirect/audit` provides three operations:
- **Audit**: Scans all redirects to detect chains and loops
- **Fix**: Resolves detected chains by updating source redirects (Loops must be managed manually)
- **Clear**: Removes audit records from database

### Results Table

Displays detected issues with:
- Source and target redirect paths
- Intermediate chain visualization (clickable redirect IDs)
- Issue type (Chain or Loop)

## Permissions

- **administer redirect audit**: Grants access to dashboard, settings, and bulk operations
