<?php

namespace Drupal\Tests\redirect_audit\Kernel\Service;

use Drupal\Tests\redirect_audit\Kernel\RedirectAuditKernelTestBase;

/**
 * Tests for RedirectAuditAnalyzer service.
 *
 * Essential tests for redirect chain and loop detection.
 *
 * @coversDefaultClass \Drupal\redirect_audit\Service\RedirectAuditAnalyzer
 *
 * @group redirect_audit
 * @codingStandardsIgnoreFile
 */
class RedirectAuditAnalyzerTest extends RedirectAuditKernelTestBase {

  /**
   * Tests analyzer detects simple chain.
   */
  public function testDetectsChain(): void {
    // Arrange: a -> b -> c.
    $redirects = $this->createRedirectChain(['a', 'b', 'c']);

    // Act.
    $result = $this->analyzer->analyzeRedirect($redirects[0]);

    // Assert: Chain detected with correct endpoints.
    $this->assertIsArray($result);
    $this->assertEquals($redirects[0]->id(), $result['source_rid']);
    // The target should be the last redirect in the chain.
    $this->assertEquals($redirects[1]->id(), $result['target_rid']);
    $this->assertFalse($result['is_loop']);
  }

  /**
   * Tests analyzer detects loops.
   */
  public function testDetectsLoop(): void {
    // Arrange: a -> b -> a.
    $redirects = $this->createRedirectLoop(['x', 'y']);

    // Act.
    $result = $this->analyzer->analyzeRedirect($redirects[0]);

    // Assert: Loop detected (source = target).
    $this->assertIsArray($result);
    $this->assertEquals($redirects[0]->id(), $result['source_rid']);
    $this->assertEquals($redirects[0]->id(), $result['target_rid']);
    $this->assertTrue($result['is_loop']);
  }

  /**
   * Tests analyzer handles redirect without problems.
   */
  public function testHandlesSingleRedirect(): void {
    // Arrange: Standalone redirect.
    $redirect = $this->createRedirect('standalone', 'final');

    // Act.
    $result = $this->analyzer->analyzeRedirect($redirect);

    // Assert: Returns null (no chain).
    $this->assertNull($result);
  }

}
