/**
 * @file
 * Redirect node page behaviors.
 */

(function ($, Drupal, drupalSettings, once) {
  /**
   * Added edit link next to editable node redirect nodes.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches links to editable menu items.
   */
  Drupal.behaviors.rn_link_edit = {
    attach(context) {
      // Find all editable menu items.
      $(once('rn_link_edit', 'li.js-redirect-node-can-edit', context))
        .each(function () {
          const $this = $(this);
          const $menuLink = $this.find('a').first();;
          // Get edit link from data attribute.
          const url = $this.data('rn-edit-url');

          // Build edit link template.
          const $editLinkTemplate = $('<a>')
            .append(
              $('<img>').attr(
                'src',
                `${
                  drupalSettings.path.baseUrl
                }core/misc/icons/bebebe/pencil.svg`,
              ),
            )
            .attr('title', Drupal.t('Click to edit this destination.'))
            .addClass('redirect-node-edit-link js-redirect-node-edit-link')
            .attr('href', url);

          // Append key combo message to title.
          let title = '';
          if ($menuLink.length > 0) {
            title = $menuLink[0].title;
          }
          if (title.length > 0) {
            title = Drupal.t('@title (Alt+Shift Click to edit)', {
              '@title': title,
            });
          }
          else {
            title = Drupal.t('(Alt+Shift Click to edit)');
          }

          // Bind key combo click event, update title, and insert link
          $menuLink
            .addEventListener('click', function (event) {
              if (event.altKey && event.shiftKey) {
                window.open(url, '_blank');
                return false;
              }
            })
            .attr('title', title)
            .prepend($editLinkTemplate);
        });
    },
  };
})(jQuery, Drupal, drupalSettings, once);
