<?php

use Drupal\Core\Update\UpdateException;
use Drupal\node\Entity\NodeType;

/**
 * Ensure default config exists on upgraded sites.
 */
function redirect_widget_post_update_ensure_default_config(&$sandbox = NULL) {
  try {
    $config = \Drupal::configFactory()->getEditable('redirect_widget.settings');

    // Static defaults (only set if missing).
    if ($config->get('widget_title') === NULL) {
      $config->set('widget_title', 'Redirect URL');
    }
    if ($config->get('widget_replace') === NULL) {
      $config->set('widget_replace', TRUE);
    }
    if ($config->get('widget_open') === NULL) {
      $config->set('widget_open', FALSE);
    }
    if ($config->get('autofill_enabled') === NULL) {
      $config->set('autofill_enabled', TRUE);
    }

    // Dynamic default: select all node bundles if empty/missing.
    $autofill_types = $config->get('autofill_types');
    if ($autofill_types === NULL || $autofill_types === []) {
      $types = [];
      if (\Drupal::moduleHandler()->moduleExists('node')) {
        $bundle_ids = array_keys(NodeType::loadMultiple());
        // Store as map: bundle => bundle (matches your form submit).
        $types = $bundle_ids ? array_combine($bundle_ids, $bundle_ids) : [];
      }
      $config->set('autofill_types', $types);
    }

    $config->save();

    // Return a plain string (safe for update logs).
    return 'Redirect Widget configuration ensured (install defaults applied).';
  }
  catch (\Throwable $e) {
    // Surface a clean, actionable error in Drush/UI.
    throw new UpdateException('Failed to ensure Redirect Widget defaults: ' . $e->getMessage());
  }
}
