<?php

declare(strict_types=1);

namespace Drupal\redirect_widget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\node\NodeInterface;
use Drupal\redirect\Entity\Redirect;

/**
 * @todo Add interface description.
 */
interface RedirectWidgetManagerInterface {


  /**
   * Injects the redirect widget into a node form.
   * 
   * @param array &$form
   *   The form we want to inject the widget into.
   *
   * @param \Drupal\node\NodeInterface $node
   *   The node for which the redirect widget is being built.
   */
  public function injectRedirectWidget(array &$form, NodeInterface $node): void;

  /**
   * Builds the redirect widget form for a given node.
   *
   * @param \Drupal\node\NodeInterface $node
   *   The node for which the redirect widget is being built.
   *
   * @return array
   *   A render array representing the redirect widget form.
   */
  public function getRedirectWidget(NodeInterface $node): array;

  /**
   * Handles submission for the redirect widget form.
   *
   * @param \Drupal\Core\Form\FormStateInterface $formState
   *   The node for which the redirect widget is being built.
   * 
   * @return void
   */
  public function submitRedirectWidgetForm(FormStateInterface &$formState): void;
  
  /**
   * Prepares or retrieves the redirect entity for a given node.
   *
   * Implementations may load an existing redirect entity associated with the
   * node, or prepare a new one for later saving.
   *
   * @param \Drupal\node\NodeInterface $node
   *   The node to which the redirect entity relates.
   *
   * @return \Drupal\redirect\Entity\Redirect | NULL
   */
  public function getRedirectEntity(NodeInterface $node): ?Redirect;

}
