# Redirect Entity Manager

Manage redirects directly from your content pages.

## Description

Redirect Entity Manager provides a streamlined interface for managing URL redirects directly from entity pages (nodes, taxonomy terms, and media). Instead of navigating to a separate redirects management page, editors can view and manage all redirects related to a specific piece of content right from the content itself.

## Features

* **Entity-integrated redirect management** - Access redirect tools via a "Redirects" tab on content pages
* **Bidirectional redirect views** - See both redirects FROM this content and TO this content in one place
* **Quick redirect creation** - Create redirects from system paths, URL aliases, or both with a simple form
* **Smart redirect detection** - Automatically detects and prevents duplicate redirects
* **Comprehensive redirect operations** - Edit, delete, and test redirects directly from the overview table
* **Flexible configuration** - Enable/disable redirect management per entity type (node, taxonomy_term, media)
* **Multi-language support** - Full support for multilingual redirects with language-specific options
* **Organized display** - Redirects grouped into "FROM this content" and "TO this content" sections

## Requirements

* Drupal 10 or 11
* [Redirect module](https://www.drupal.org/project/redirect)

## Installation

1. Install the Redirect module if not already installed:
   ```bash
   composer require drupal/redirect
   ```

2. Enable the Redirect Entity Manager module:
   ```bash
   drush en redirect_entity_manager -y
   ```

   Or via the Drupal UI at `/admin/modules`

## Configuration

1. Navigate to `/admin/config/search/redirect-entity-manager`
2. Select which entity types should display the redirect management tab:
   - Content (nodes)
   - Taxonomy terms
   - Media
3. Save the configuration
4. Clear the cache to rebuild local tasks

## Usage

### Viewing Redirects

1. Navigate to any enabled entity (node, taxonomy term, or media)
2. Click the "Redirects" tab
3. View redirects organized into two sections:
   - **Redirects FROM this content paths** - Redirects that start from this content
   - **Redirects TO this content paths** - Redirects that point to this content

### Creating Redirects FROM Content

1. Click the "Redirect from this content" button
2. Select which path(s) to redirect from:
   - System path (e.g., `/node/123`)
   - URL alias (e.g., `/my-page`)
   - Both
3. Enter the destination path
4. Select the redirect status code (301, 302, 303, or 307)
5. Choose the language
6. Click "Save"

### Creating Redirects TO Content

1. Click the "Redirect to this content" button
2. This opens the standard Redirect module form pre-filled with the current content as the destination
3. Enter the source path and save

### Managing Existing Redirects

Each redirect in the table has three operations:
- **Edit** - Modify the redirect settings
- **Delete** - Remove the redirect
- **Test** - Open the redirect source URL in a new tab to verify it works

## Permissions

This module uses the "administer redirects" permission from the Redirect module. Users need this permission to:
- View the Redirects tab
- Create new redirects
- Edit existing redirects
- Delete redirects

## Technical Details

### Routes

The module provides routes for:
- `/node/{node}/redirects` - Node redirect management
- `/taxonomy/term/{taxonomy_term}/redirects` - Taxonomy term redirect management
- `/media/{media}/redirects` - Media redirect management
- `/admin/config/search/redirect-entity-manager` - Module settings

### Configuration

Settings are stored in `redirect_entity_manager.settings`:
- `enabled_entity_types` - Array of enabled entity type IDs

### Local Tasks

The module dynamically creates local tasks (tabs) based on the configuration using `hook_local_tasks_alter()`.

## Troubleshooting

### Redirects tab not appearing

1. Check that the entity type is enabled in the configuration
2. Verify the user has the "administer redirects" permission
3. Clear the cache: `drush cr`

### Duplicate redirect warnings

The module prevents creating duplicate redirects. If you see a warning about an existing redirect, check the redirect list to find the conflicting entry.

## Maintainers

Current maintainers:
- abu-zakham - [abu-zakham]

## License

This project is licensed under the GNU General Public License v2.0 or later.
