<?php

namespace Drupal\redis_cache_clear\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class RedisCacheClearSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['redis_cache_clear.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'redis_cache_clear_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('redis_cache_clear.settings');

    $form['interval'] = [
      '#type' => 'number',
      '#title' => $this->t('Cache Clear Interval'),
      '#description' => $this->t('Enter the interval in seconds between Redis cache clears. Default is 86400 (1 day).'),
      '#default_value' => $config->get('interval') ?? 86400,
      '#min' => 60,
      '#step' => 60,
      '#required' => TRUE,
    ];

    $form['prefix'] = [
        '#type' => 'textfield',
        '#title' => $this->t('Redis Key Prefix'),
        '#description' => $this->t('Enter the Redis key prefix to target for deletion. Example: <code>bc_</code>. If left empty, the default prefix will be used.'),
        '#default_value' => $config->get('prefix') ?? '',
        '#maxlength' => 64,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('redis_cache_clear.settings')
      ->set('interval', $form_state->getValue('interval'))
      ->set('prefix', $form_state->getValue('prefix'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
