<?php

namespace Drupal\reference_by_view_mode\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\reference_by_view_mode\Plugin\EntityReferenceSelection\ParagraphViewModeSelection;
use Symfony\Component\DependencyInjection\ContainerInterface;

class ViewModeSelectionDeriver extends DeriverBase implements ContainerDeriverInterface {

  public function __construct(
    protected readonly EntityTypeManagerInterface $entityTypeManager,
  ) {}

  public static function create(ContainerInterface $container, $base_plugin_id): static {
    return new static($container->get('entity_type.manager'));
  }

  public function getDerivativeDefinitions($base_plugin_definition): array {
    $entity_types = array_keys($this->entityTypeManager->getDefinitions());

    // Add support for Paragraph, see https://www.drupal.org/node/3559561.
    if (($key = array_search('paragraph', $entity_types)) !== FALSE) {
      $this->buildParagraphPlugin($base_plugin_definition, ['paragraph']);
      unset($entity_types[$key]);
    }

    $this->buildBasePlugin($base_plugin_definition, $entity_types);

    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

  /**
   * @see \Drupal\paragraphs\Plugin\Field\FieldWidget\InlineParagraphsWidget::getAllowedTypes
   * @see \Drupal\paragraphs\Plugin\Field\FieldWidget\ParagraphsWidget::getAllowedTypes
   * @see \Drupal\paragraphs_library\Plugin\Validation\Constraint\ParagraphsLibraryItemHasAllowedParagraphsTypeConstraintValidator::validate
   */
  private function buildParagraphPlugin(array $base_plugin_definition, array $entity_types): void {
    assert(is_string($base_plugin_definition['label']) || $base_plugin_definition['label'] instanceof \Stringable);

    $this->derivatives['paragraph'] = $base_plugin_definition;
    $this->derivatives['paragraph']['class'] = ParagraphViewModeSelection::class;
    $this->derivatives['paragraph']['entity_types'] = $entity_types;
    $this->derivatives['paragraph']['base_plugin_label'] = (string) $base_plugin_definition['label'];
  }

  /**
   * @see \Drupal\Component\Plugin\Discovery\DerivativeDiscoveryDecorator::encodePluginId
   * @see \Drupal\Core\Field\Plugin\Field\FieldType\EntityReferenceItem::fieldSettingsForm
   */
  private function buildBasePlugin(array $base_plugin_definition, array $entity_types): void {
    assert(is_string($base_plugin_definition['label']) || $base_plugin_definition['label'] instanceof \Stringable);

    // Use a falsy-key to mark derivative as base plugin.
    $this->derivatives[0] = $base_plugin_definition;
    $this->derivatives[0]['entity_types'] = $entity_types;
    $this->derivatives[0]['base_plugin_label'] = (string) $base_plugin_definition['label'];
  }

}
