<?php

namespace Drupal\reference_by_view_mode\Plugin\EntityReferenceSelection;

use Drupal\Core\Entity\EntityDisplayRepositoryInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\paragraphs\Plugin\EntityReferenceSelection\ParagraphSelection;
use Symfony\Component\DependencyInjection\ContainerInterface;

class ParagraphViewModeSelection extends ParagraphSelection implements ContainerFactoryPluginInterface {
  use ViewModeSelectionTrait {
    calculateDependencies as private traitCalculateDependencies;
  }

  protected EntityDisplayRepositoryInterface $entityDisplayRepository;

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return parent::create($container, $configuration, $plugin_id, $plugin_definition)
      ->setEntityDisplayRepository($container->get('entity_display.repository'));
  }

  public function setEntityDisplayRepository(EntityDisplayRepositoryInterface $entity_display_repository): static {
    $this->entityDisplayRepository = $entity_display_repository;
    return $this;
  }

  public function getSortedAllowedTypes(): array {
    $result = [];

    $configuration = $this->getConfiguration();
    $entity_type_id = $configuration['target_type'];
    assert(is_string($entity_type_id));
    $view_modes = array_filter((array) ($configuration['target_view_modes'] ?? []));
    $multiple_operator = $configuration['multiple_operator'] ?? 'OR';
    assert(is_string($multiple_operator));

    $bundles = $this->viewModesToBundles($entity_type_id, $view_modes, $multiple_operator);
    uasort($bundles, fn(string $a, string $b): int => $a <=> $b);

    $i = 0;
    foreach ($bundles as $machine_name => $bundle) {
      $result[$machine_name] = [
        'label' => $bundle,
        'weight' => $i++,
      ];
    }

    return $result;
  }

}
