<?php

namespace Drupal\reference_by_view_mode\Plugin\EntityReferenceSelection;

use Drupal\Core\Entity\Attribute\EntityReferenceSelection;
use Drupal\Core\Entity\EntityDisplayRepositoryInterface;
use Drupal\Core\Entity\EntityReferenceSelection\SelectionPluginBase;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\reference_by_view_mode\Plugin\Derivative\ViewModeSelectionDeriver;
use Symfony\Component\DependencyInjection\ContainerInterface;

#[EntityReferenceSelection(
  id: "view_mode",
  label: new TranslatableMarkup("Reference by available view mode(s)"),
  group: "view_mode",
  weight: 0,
  deriver: ViewModeSelectionDeriver::class,
)]
class ViewModeSelection extends SelectionPluginBase implements ContainerFactoryPluginInterface {
  use ViewModeSelectionTrait;

  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected readonly EntityTypeManagerInterface $entityTypeManager,
    protected readonly EntityTypeBundleInfoInterface $entityTypeBundleInfo,
    protected readonly EntityDisplayRepositoryInterface $entityDisplayRepository,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
      $container->get('entity_type.bundle.info'),
      $container->get('entity_display.repository'),
    );
  }

}
