/**
 * @file
 * Drupal messages compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-messages-compatibility';

  /**
   * Our once() identifier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(
    onceName, html,
  )).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

    // Don't save Drupal messages to Turbo's cache.
    //
    // These are inherently temporary and in response to various actions that
    // are not usually repeated by navigating back to a page.
    //
    // Note that we're specifically looking for the messages placed after the
    // fallback element to avoid false positives where a message may be embedded
    // in content and thus is content that should be cached.
    $(event.target).find([
      '[data-drupal-messages-fallback]',
      '[data-drupal-messages]',
    ].join(' + ')).attr('data-refreshless-temporary', true);

  });

})(document.documentElement, jQuery, once);
