![Stylized "RefreshLess"](assets/optimized/title.svg)

*RefreshLess* layers JavaScript-based navigation on top of Drupal's existing
server-rendered HTML to provide the kind of smooth, fast, and responsive
experience users expect. By fully embracing [progressive
enhancement](https://en.wikipedia.org/wiki/Progressive_enhancement), you don't
need to choose between a web site/web app that continues to work if JavaScript
breaks **or** something that feels like a [single page app
(SPA)](https://en.wikipedia.org/wiki/Single-page_application) user experience -
you can have both.

Compared to an SPA:

* Provides much higher [resiliency](https://resilientwebdesign.com/) in unexpected or adverse network or runtime conditions where JavaScript fails to load or execute correctly. In such situations, your users still have a functioning site/app that falls back to traditional page loads. [The browser is the most hostile runtime environment](https://molily.de/robust-javascript/#the-browser-as-a-runtime-environment) after all.

* Reuses Drupal's server-rendered HTML, saving you the development time and cost of re-implementing a whole new front-end, while making use of Drupal's Twig templates, asset library system, caching, security, and so on.

Compared to a plain server-rendered HTML site:

* Navigation feels faster and more fluid because the browser no longer needs to re-initialize all CSS and JavaScript on every page request.

* Page transitions (with or without [the View Transitions API](https://developer.mozilla.org/en-US/docs/Web/API/View_Transitions_API)), [morphing](https://github.com/bigskysoftware/idiomorph), and [permanent/persistent elements](https://turbo.hotwired.dev/handbook/building#persisting-elements-across-page-loads) (think media players, etc.) are now possible.

* Everyone thinks you're super cool.

# Requirements

Please see [our requirements documentation](docs/user/requirements.md).

# Installation

Please see [our installation documentation](docs/user/install.md) for important
steps.

# Documentation

We have [a documentation
site](https://project.pages.drupalcode.org/refreshless/) that contains
information on installing and using RefreshLess, integrating with it
(events, behaviours, etc.), how to get involved with its development, and
more.

# Credits

Special thanks to [Wim Leers](https://www.drupal.org/u/wim-leers) and
[contributors](https://www.drupal.org/node/2693129/committers) on the 1.x
version of this module, which inspired the 2.x rework and provided a foundation
to build on.

## Branding

Logo and title created with [Inkscape](https://inkscape.org/) with the [Rubik
font](https://www.fontsquirrel.com/fonts/rubik).
