<?php

declare(strict_types=1);

namespace Drupal\refreshless\Service;

use Drupal\refreshless\Service\FactoryWithValueClassInterface;
use Drupal\refreshless\Value\RequestWrapperInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Interface for a RefreshLess request wrapper factory service.
 */
interface RequestWrapperFactoryInterface extends FactoryWithValueClassInterface {

  /**
   * Create a value object from a provided request object.
   *
   * @param \Symfony\Component\HttpFoundation\Request|null $request
   *   The request object to create from; if not provided, will use the current
   *   request.
   *
   * @return \Drupal\refreshless\Value\RequestWrapperInterface
   *   A new a value object instance with values set from the request.
   */
  public function fromRequest(
    ?Request $request = null,
  ): RequestWrapperInterface;

}
