<?php

declare(strict_types=1);

namespace Drupal\refreshless\Value;

/**
 * Interface for value objects that include drupalSettings values.
 */
interface ValueObjectWithDrupalSettingsInterface {

  /**
   * Format the page state into an array suitable for drupalSettings.
   *
   * @return array
   *   An array of page state information containing 'libraries', 'theme', and
   *   'themeToken' keys.
   */
  public function toDrupalSettings(): array;

  /**
   * Create from a provided drupalSettings array.
   *
   * @param array $settings
   *   A array containing required keys. See implementing classes for what they
   *   require.
   *
   * @return self
   *   A new instance with values set.
   */
  public static function fromDrupalSettings(array $settings): self;

}
