/**
 * @file
 * RefreshLess announcements for assistive software.
 *
 * @see https://github.com/hotwired/turbo/issues/774
 *   Turbo issue with a lot of good discussion and ideas.
 *
 * @see https://www.drupal.org/project/refreshless/issues/2695777
 *   8.x-1.x for this same functionality.
 */
(function(html, Drupal, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-announce';

  /**
   * once() identfier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(onceName, html)).on(`refreshless:load.${eventNamespace}`, (event) => {

    // Don't announce on the initial load.
    if (event.detail.initial === true) {
      return;
    }

    Drupal.announce(Drupal.t('New page loaded: !title', {
      '!title': document.title,
    }), 'assertive');

  });

})(document.documentElement, Drupal, jQuery, once);
