<?php

declare(strict_types=1);

namespace Drupal\refreshless_turbo\Pager;

use Drupal\Core\Pager\PagerManagerInterface;
use Drupal\Core\Pager\PagerParametersInterface;
use Symfony\Component\DependencyInjection\Attribute\AutowireDecorated;

/**
 * Decorated pager manager to remove the 'ajax_page_state' query parameter.
 *
 * @see \Drupal\refreshless_turbo\PathProcessor\AjaxPageStatePathProcessor
 *   Describes the problem this addresses.
 */
class PagerManager implements PagerManagerInterface {

  /**
   * Service constructor; saves dependencies.
   *
   * @param \Drupal\Core\Pager\PagerManagerInterface $decorated
   *   The pager manager that we decorate.
   */
  public function __construct(
    #[AutowireDecorated]
    protected readonly PagerManagerInterface $decorated,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function createPager($total, $limit, $element = 0) {

    return $this->decorated->createPager($total, $limit, $element);

  }

  /**
   * {@inheritdoc}
   */
  public function getPager($element = 0) {

    return $this->decorated->getPager($element);

  }

  /**
   * {@inheritdoc}
   */
  public function findPage(int $pager_id = 0): int {

    return $this->decorated->findPage($pager_id);

  }

  /**
   * {@inheritdoc}
   */
  public function getUpdatedParameters(array $query, $element, $index) {

    $updated = $this->decorated->getUpdatedParameters($query, $element, $index);

    if (isset($updated['ajax_page_state'])) {
      unset($updated['ajax_page_state']);
    }

    return $updated;

  }

  /**
   * {@inheritdoc}
   */
  public function getMaxPagerElementId() {

    return $this->decorated->getMaxPagerElementId();

  }

  /**
   * {@inheritdoc}
   */
  public function reservePagerElementId(int $element): void {

    $this->decorated->reservePagerElementId($element);

  }

}
