<?php

declare(strict_types=1);

namespace Drupal\refreshless\Service;

use Drupal\refreshless\Service\RequestWrapperFactoryInterface;
use Drupal\refreshless\Value\RequestWrapper;
use Drupal\refreshless\Value\RequestWrapperInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Default implementation of the RefreshLess request wrapper factory service.
 *
 * This is intended to be decorated by RefreshLess implementations with their
 * own getClass() method, their own value object implementation, and whatever
 * other changes they may need to make.
 */
class RequestWrapperFactory implements RequestWrapperFactoryInterface {

  /**
   * Constructor; saves dependencies.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $requestStack
   *   The request stack.
   */
  public function __construct(
    protected readonly RequestStack $requestStack,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getClass(): string {
    return RequestWrapper::class;
  }

  /**
   * {@inheritdoc}
   */
  public function fromRequest(
    ?Request $request = null,
  ): RequestWrapperInterface {

    if ($request === null) {
      $request = $this->requestStack->getCurrentRequest();
    }

    return $this->getClass()::fromRequest($request);

  }

}
