Why not just build a front-end using React, Vue, etc.?
:   Let's turn that question around: what do they offer that can't be achieved by progressively enhanced server-rendered HTML and all the additional resilience/fallbacks it provides? There are legitimate use-cases for these frameworks where their drawbacks are mitigated (e.g. controlled environments such as [Electron](https://www.electronjs.org/) apps), but when it comes to the open web, [the browser is the most hostile runtime environment](https://molily.de/robust-javascript/#the-browser-as-a-runtime-environment) and if anything goes wrong with your JavaScript framework loading or executing, your site/app is unusable. See [the motivation page](motivation.md) for a more in-depth discussion.

What about decoupled/headless Drupal?
:   RefreshLess is specifically engineered to work with an active Drupal site, so the answer is that it depends: if you're using a decoupled approach where a Drupal site (running RefreshLess) is serving the content but it's pulling content from another back-end, then yes; if it's a static site or anything other than a Drupal site acting as the front-end, then probably not.

What about offline support?
:   This is completely compatible with the RefreshLess approach. See the [Service Worker API](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) and [the PWA module](https://www.drupal.org/project/pwa). In the future we hope to create an integration between the two modules to make it as simple as possible to allow for offline and instantly loading pages.

Does this replace Drupal's Ajax framework? How does it relate to that?
:   No, we don't replace Drupal's Ajax framework, and in fact are very careful not not interfere with links or form elements that the Ajax system handles. If you're interested in helping modernize Drupal's Ajax framework, we would like to point you to [#3404409: [Plan] Gradually replace Drupal's AJAX system with HTMX](https://www.drupal.org/project/drupal/issues/3404409).

Why does this project still use jQuery?
:   Please read [Why I still use jQuery in 2025](https://ambientimpact.com/web/essays/why-i-still-use-jquery).
