## JavaScript aggregation

Aggregation works but there are limitations:

* We force all JavaScript into the `<head>` but add the `defer` attribute as [recommended by the Turbo documentation](https://turbo.hotwired.dev/handbook/building#loading-your-application%E2%80%99s-javascript-bundle); this is necessary to prevent Turbo re-evaluating `<script>` elements that it finds in the `<body>`; [core is patched to allow aggregating JavaScript with the `defer` attribute](https://www.drupal.org/project/drupal/issues/1587536).

* [We alter the core JavaScript aggregation behaviour to be additive during Turbo navigation](https://www.drupal.org/project/refreshless/issues/3414538), tracking what libraries are already loaded on a page in a similar way to Drupal's Ajax system. Because this can have multiple variations per page, Drupal's anonymous page caching is disabled for Turbo requests, though the dynamic page cache and render cache are unaffected.

* Turbo itself is not aggregated/minified at the moment as it starts to behave unpredictably and sometimes attach more than once to a page if aggregated.
