Most or all Drupal behaviours should work as expected, but if you're
encountering errors or strange issues with behaviours you've written, we
recommend the following:

* They should have detach callbacks that fully clean up changes their attach callbacks make, restoring elements on the page as if the attach was never applied.

* Don't store references to elements outside of behaviour callbacks unless you absolutely have to. They can and will get out of sync with the DOM, resulting in references to elements no longer on the page.

* Always wrap your attach and detach operations in `once()` and `once.remove()` respectively via [Drupal's `@drupal/once` library](https://www.npmjs.com/package/@drupal/once) so that you don't accidentally attach more than once nor attempt to detach when your behaviour is not attached.

## Detach triggers

Many examples of behaviours, when they do bother to include a detach callback, often miss the fact that Drupal provides a third parameter to all detach callbacks: the `trigger`. This is a string that indicates the reason for the detach. Most commonly, this is `unload`, which is what Drupal core provides when leaving a page and what RefreshLess invokes behaviour detach with before navigating to a new page. Another example that core uses is `serialize` on form elements before an Ajax form submit.

### Caching

In addition to the above, RefreshLess triggers two additional detaches with new `trigger` values for [caching](caching.md):

`refreshless:before-cache`
:   Triggered before a page is about to be cached. This occurs before the `unload` trigger.

`refreshless:cached-snapshot`
:   Triggered when a page snapshot has been restored from cache for display, allowing behaviours to clean up the snapshot. This occurs right before behaviours are attached.
