/**
 * @file
 * Drupal table select compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-media-library-view-compatibility';

  /**
   * Our once() identfier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(
    onceName, html,
  )).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

    $(once.remove(
      'media-library-select-all',
      '.js-media-library-view[data-view-display-id="page"]',
      event.target,
    )).find('.media-library-select-all').remove();

  });

})(document.documentElement, jQuery, once);
