/**
 * @file
 * Drupal Navigation module compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-navigation-compatibility';

  /**
   * Our once() identifier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  // A lot of core's Navigation behaviours lack detach callbacks, so when the
  // Navigation is restored from a cached snapshot, it'll still have all the
  // once() identifiers on various elements which prevents its behaviours
  // attaching. The quick and dirty solution is to run once.remove() ourselves
  // prior to caching.
  //
  // @todo Contribute detach callbacks to core and remove this?
  $(once(
    onceName, html,
  )).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

    once.remove('admin-toolbar-document-triggers-listener', event.target);

    once.remove(
      'admin-toolbar-trigger', '[aria-controls="admin-toolbar"]', event.target,
    );

    once.remove('keyboard-processed', '.admin-toolbar', event.target);

    once.remove('navigation', '.admin-toolbar', event.target);

    once.remove('dropdown-trigger', '[data-drupal-dropdown]', event.target);

    once.remove(
      'toolbar-menu-trigger', '[data-toolbar-menu-trigger]', event.target,
    );

    once.remove(
      'toolbar-menu-link', 'a.toolbar-menu__link, a.toolbar-button',
      event.target,
    );

    once.remove('toolbar-popover', '[data-toolbar-popover]', event.target);

    once.remove('tooltip-trigger', '[data-drupal-tooltip]', event.target);

  });

})(document.documentElement, jQuery, once);
