/**
 * @file
 * Parse inline JSON and initialize the drupalSettings global object.
 *
 * This is very similar to the Drupal core library and was originally written
 * to work around RefreshLess not working correctly when JavaScript aggregation
 * was enabled; the only differences now are easier to follow formatting and
 * better documentation of what's done and why.
 */
(function() {

  'use strict';

  /**
   * The drupalSettings <script> element selector.
   *
   * Note that this doesn't include the leading '>' combinator for XSS
   * hardening.
   *
   * @type {String}
   */
  const scriptSelector = 'script[type="application/json"][data-drupal-selector="drupal-settings-json"]';

  /**
   * The drupalSettings <script> element.
   *
   * Note the use of the '>' combinator to prevent XSS exploits when CSP is on.
   *
   * @type {HTMLElement}
   */
  const settingsElement = document.querySelector(
    `head > ${scriptSelector}, body > ${scriptSelector}`,
  );

  /**
   * Variable generated by Drupal with all the configuration created from PHP.
   *
   * @global
   *
   * @type {object}
   */
  window.drupalSettings = {};

  if (settingsElement !== null) {
    window.drupalSettings = JSON.parse(settingsElement.textContent);
  }

})();
