/**
 * @file
 * Client-side prefetch exclusions based on drupalSettings.
 */
(function(html, drupalSettings, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-prefetch-exclusions';

  /**
   * Our once() identifier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(onceName, html))
  .on(`refreshless:before-prefetch.${eventNamespace}`, (event) => {

    const excludePaths = drupalSettings.refreshless.prefetchExcludePaths;

    if (excludePaths.indexOf(event.detail.url.pathname) > -1) {
      event.preventDefault();
    }

  });

})(document.documentElement, drupalSettings, jQuery, once);
