/**
 * @file
 * Gin table header compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-gin-tableheader-compatibility';

  /**
   * once() identfier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(onceName, html)).each(() => {

    $(html).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

      // Note that despite console errors, this works, and we don't want to
      // remove the 'sticky-enabled' class because that ends up breaking Gin's
      // select all functionality.
      $(once.remove(
        'ginTableHeaderSticky',
        'table.position-sticky, table.sticky-header',
        event.target,
      ));

    });

  });

})(document.documentElement, jQuery, once);
