<?php

declare(strict_types=1);

namespace Drupal\refreshless\StackMiddleware;

use Drupal\refreshless\Service\RefreshlessKillSwitchInterface;
use Drupal\refreshless\Service\RequestWrapperFactoryInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\HttpKernelInterface;

/**
 * RefreshLess kill switch cookie middleware.
 */
class RefreshlessKillSwitch implements HttpKernelInterface {

  /**
   * Constructor; saves dependencies.
   *
   * @param \Symfony\Component\HttpKernel\HttpKernelInterface $httpKernel
   *   The wrapped HTTP kernel.
   *
   * @param \Drupal\refreshless\Service\RefreshlessKillSwitchInterface $killSwitch
   *   The RefreshLess kill switch service.
   *
   * @param \Drupal\refreshless\Service\RequestWrapperFactoryInterface $requestWrapperFactory
   *   The RefreshLess request wrapper factory.
   */
  public function __construct(
    protected readonly HttpKernelInterface $httpKernel,
    protected readonly RefreshlessKillSwitchInterface $killSwitch,
    protected readonly RequestWrapperFactoryInterface $requestWrapperFactory,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function handle(
    Request $request, int $type = self::MAIN_REQUEST, bool $catch = true,
  ): Response {

    if (
      $type === self::MAIN_REQUEST &&
      $this->requestWrapperFactory->fromRequest($request)->isDisabled()
    ) {

      $this->killSwitch->trigger();

    }

    return $this->httpKernel->handle($request, $type, $catch);

  }

}
