<?php

declare(strict_types=1);

namespace Drupal\refreshless\Value;

use Drupal\refreshless\Value\ValueObjectWithCookieInterface;
use Drupal\refreshless\Value\ValueObjectWithDrupalSettingsInterface;
use Drupal\refreshless\Value\ValueObjectWithRequestInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Interface for a RefreshLess page state value object.
 */
interface PageStateInterface extends ValueObjectWithCookieInterface, ValueObjectWithDrupalSettingsInterface, ValueObjectWithRequestInterface {

  /**
   * Get any libraries already on the page.
   *
   * @return string[]
   */
  public function getLibraries(): array;

  /**
   * Set the libraries already on the page.
   *
   * @param string[]|string $libraries
   *
   * @return self
   *   The instance for chaining.
   */
  public function setLibraries(array|string $libraries): self;

  /**
   * Get the theme token, if any.
   *
   * @return string
   */
  public function getThemeToken(): string;

  /**
   * Set the theme token.
   *
   * @param string $themeToken
   *
   * @return self
   *   The instance for chaining.
   */
  public function setThemeToken(string $themeToken): self;

  /**
   * Get the theme name.
   *
   * @return string
   *   The theme name.
   */
  public function getTheme(): string;

  /**
   * Set the theme name.
   *
   * @param string $theme
   *   The theme name to set.
   *
   * @return self
   *   The instance for chaining.
   */
  public function setTheme(string $theme): self;

}
