<?php

declare(strict_types=1);

namespace Drupal\refreshless\Value;

/**
 * Interface for value objects that include a cookie.
 */
interface ValueObjectWithCookieInterface {

  /**
   * Create from a provided cookie value.
   *
   * @param string $value
   *   The cookie value to create from.
   *
   * @return self
   *   A new instance with values set.
   */
  public static function fromCookieValue(string $value): self;

  /**
   * Get the cookie name that this value object includes.
   *
   * @return string
   *   The cookie name that this value object includes.
   *
   * @internal This is primarily intended for internal use to allow a single
   *   source of truth for a cookie name. External code should not have to know
   *   the exact cookie name in almost any cases, instead calling public
   *   services and interacting with specific value object methods to set or
   *   retrieve data.
   */
  public static function getCookieName(): string;

}
