Transitioning gracefully between pages or when submitting a form is one of the UX improvements RefreshLess offers. To enable this, install the `refreshless_transitions` module, which will attach a component that provides an overlay that's transitioned in and out while delaying rendering of the incoming content until the page is fully hidden. When the module is installed, several new [page transition events](events.md#page-transition-events) are triggered that you can listen to.

# Customizing transitions

The default behaviour of the overlay is a simple opacity fade in and out, but this can be customized by a theme with more elaborate [animations](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_animations/Using_CSS_animations) and [transitions](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_transitions). The overlay CSS is built with a number of [custom properties](https://developer.mozilla.org/en-US/docs/Web/CSS/--*) that can be set by a theme to alter the durations of the fades, the z-index of the overlay, and the colour of the overlay.

*The overlay JavaScript relies heavily on the opacity transition ocurring, by listening to [the `transitionend` event](https://developer.mozilla.org/en-US/docs/Web/API/Element/transitionend_event), so we strongly recommend not removing the opacity transition as that will break the overlay.* If you do not want the overlay to fade the page in and out, you can remove its background colour so that it never hides the page, which will allow the opacity to still trigger the the `transitionend` event.

# Transition state attribute

The overlay JavaScript sets a `data-refreshless-page-transition-state` attribute on the `<html>` element and updates it so that you can have your CSS react to transitions. The following values are provided:

`initial`
:   Set when first attached after a full page load, and only changed from this value when the first transition out begins.

`hiding`
:   The overlay has started to transition the page out.

`hidden`
:   The overlay has finished transitioning out and the page is fully hidden.

`revealing`
:   The overlay has started to transition the page in.

`revealed`
:   The overlay has finished transitioning the page in. It will remain this value until a transition out starts.

As mentioned above, after a full page load, the value will be `initial` until a RefreshLess navigation occurs, so you can use the following selector to target any CSS reveal animations only on a full page load:

```css
html[data-refreshless-page-transition-state]:not([data-refreshless-page-transition-state='initial']) .your-selector {
  /* Full page load properties here. */
}
```

This is important to ensure a smooth UX, because when caching is enabled, a preview of the page rendering will trigger the browser to run [CSS animations](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_animations/Using_CSS_animations), as will the fresh copy that gets swapped in shortly thereafter, causing a double flash of animations. By wrapping your full page load animation in the above selector, you can prevent this.
