/**
 * @file
 * Drupal contextual links compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-contextual-compatibility';

  /**
   * Our once() identifier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(
    onceName, html,
  )).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

    // Remove contextual links from the cached preview to avoid appearance of
    // broken UI if the user attempts to click them and they predictable won't
    // do anything. This effectively undoes what core's attach does, but core
    // does not have a detach callback at the time of writing.
    $(once.remove(
      'contextual-render', '[data-contextual-id]', event.target,
    )).empty().removeClass(['contextual', 'open'])
    .closest('.contextual-region').removeClass('focus');

  });

})(document.documentElement, jQuery, once);
