/**
 * @file
 * Drupal table select compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-tableselect-compatibility';

  /**
   * once() identfier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(
    onceName, html,
  )).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

    $(once.remove(
      'ClaroBulkActions',
      '[data-drupal-views-bulk-actions]',
      event.target,
    ));

    $(once.remove(
      'table-select',
      $(event.target).find(
        // @todo Remove :not(.gin--sticky-table-header) and re-insert the
        //  select all checkbox in the Gin sub-module instead.
        'table:not(.gin--sticky-table-header) th.select-all',
      ).closest('table'),
    )).find('th.select-all .form-checkbox').remove();

  });

})(document.documentElement, jQuery, once);
