Building on [caching](caching.md), we offer an opt-in feature that will automatically preload links into the cache as the user scrolls them into view, allowing for instant previews when a user clicks one. This is especially impactful on mobile, where Turbo doesn't prefetch links on hover as it does on desktop.

As this is an opt-in feature, you must install the `refreshless_preloader` module and add a `data-refreshless-lazy-preload` to a container element or directly on a link to opt it in. Note that once a tree is opted in, it's possible to opt out a descendent container or link by setting `data-refreshless-lazy-preload="false"` on it.

See also [cache events](events.md#cache-events) which allow for responding to preloads.

Note that this implemented in a throttled way to avoid sending too many network requests at once, and uses [an `IntersectionObserver`](https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API) to lazily send requests only as links are scrolled into view.
