<?php

declare(strict_types=1);

namespace Drupal\refreshless_preloader\Hooks;

use Drupal\hux\Attribute\Alter;

/**
 * Library hook implementations.
 */
class Library {

  #[Alter('library_info')]
  /**
   * Add our library as a dependency of 'refreshless_turbo/refreshless'.
   *
   * @see hook_library_info_alter
   */
  public function addLibrary(
    array &$libraries, string $extension,
  ): void {

    if ($extension !== 'refreshless_turbo') {
      return;
    }

    $libraries['refreshless'][
      'dependencies'
    ][] = 'core/components.refreshless--lazy-link-preloader';

  }

}
