/**
 * @file
 * Drupal media library click to select compatibility for RefreshLess.
 */
(function(html, $, once) {

  'use strict';

  /**
   * Our event namespace.
   *
   * @type {String}
   *
   * @see https://learn.jquery.com/events/event-basics/#namespacing-events
   */
  const eventNamespace = 'refreshless-turbo-media-library-click-to-select-compatibility';

  /**
   * Our once() identfier.
   *
   * @type {String}
   */
  const onceName = eventNamespace;

  $(once(
    onceName, html,
  )).on(`refreshless:before-cache.${eventNamespace}`, (event) => {

    once.remove(
      'media-library-click-to-select',
      '.js-click-to-select-trigger, .js-click-to-select-checkbox input',
      event.target,
    );

    once.remove(
      'media-library-click-to-select-hover',
      '.js-click-to-select-trigger, .js-click-to-select-checkbox',
      event.target,
    );

  });

})(document.documentElement, jQuery, once);
