<?php

declare(strict_types=1);

namespace Drupal\refreshless\Value;

use Symfony\Component\HttpFoundation\Request;

/**
 * Interface for value objects that include a request object.
 */
interface ValueObjectWithRequestInterface {

  /**
   * Create from a provided Symfony Request object.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request object to create from.
   *
   * @return self
   *   A new instance with values set.
   */
  public static function fromRequest(Request $request): self;

  /**
   * Get the Symfony Request object this object includes.
   *
   * @return \Symfony\Component\HttpFoundation\Request
   *   The request object.
   */
  public function getRequest(): Request;

}
