<?php

namespace Drupal\registered_organisations;

use Drupal\Component\Plugin\Factory\DefaultFactory;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Service class for GovUK Notify.
 */
class OrganisationManager extends DefaultPluginManager implements OrganisationManagerInterface {

  /**
   * Constructs an Organisation object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
          'Plugin/OrganisationRegister',
          $namespaces,
          $module_handler,
          'Drupal\registered_organisations\OrganisationRegisterInterface',
          'Drupal\registered_organisations\Annotation\OrganisationRegister'
      );

    $this->alterInfo('registered_organisations_info');
    $this->setCacheBackend($cache_backend, 'registered_organisations_info_plugins');
    $this->factory = new DefaultFactory($this->getDiscovery());
  }

  /**
   * {@inheritDoc}
   */
  public function lookupOrganisation(string $id, array $definition) {
    $plugin = $this->createInstance($definition['id'], $definition);

    return $plugin->getCompany($id);
  }

  /**
   * {@inheritDoc}
   */
  public function searchOrganisation(string $term, array $definition): array {
    $plugin = $this->createInstance($definition['id'], $definition);

    return $plugin->findCompany($term);
  }

}
