<?php

namespace Drupal\registered_organisations;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Interface for Organisation Manager Services.
 */
interface OrganisationManagerInterface {

  /**
   * Constructor.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler);

  /**
   * Lookup an organisation given it's unique identifier.
   *
   * @param string $id
   *   The ID for the organisation.
   * @param array $definition
   *   The plugin definition to use.
   *
   * @return mixed|null
   *   A company record.
   */
  public function lookupOrganisation(string $id, array $definition);

  /**
   * Search for an organisation by name or term.
   *
   * @param string $term
   *   The organisation name to search for.
   * @param array $definition
   *   The plugin definition to use.
   *
   * @return array
   *   A company record.
   */
  public function searchOrganisation(string $term, array $definition): array;

}
