<?php

namespace Drupal\registered_organisations;

/**
 * Interface for Organisation Register Plugin.
 */
interface OrganisationRegisterInterface {

  /**
   * Cache prefix.
   *
   * @var string
   */
  const CACHE_PREFIX = 'registered_organisations';

  /**
   * The rate limit timeout in seconds.
   *
   * @var int
   */
  const RATE_LIMIT_TIMEOUT = 300;

  /**
   * Get a company by ID.
   *
   * @param string $id
   *   A company ID to be looked up.
   *
   * @return OrganisationProfileInterface|null
   *   The company record.
   */
  public function getCompany(string $id): OrganisationProfileInterface|null;

  /**
   * Get a company by name.
   *
   * @param string $name
   *   A company name to be looked up.
   *
   * @return OrganisationProfileInterface[]
   *   An array of matched company records.
   */
  public function findCompany(string $name): array;

}
