<?php

namespace Drupal\registered_organisations;

/**
 * Interface for Organisation Register Plugin.
 */
interface OrganisationProfileInterface {

  /**
   * Get the register plugin used to retrieve this company record.
   *
   * @return string
   *   The register plugin.
   */
  public function getRegister(): string;

  /**
   * Get the uniquely identifiable organisation number recorded in the register.
   *
   * @return string
   *   The ID or organisation number.
   */
  public function getId(): string;

  /**
   * Get the organisation name.
   *
   * @return string
   *   The organisation name.
   */
  public function getName(): string;

  /**
   * Get the organisation type.
   *
   * @return string
   *   The organisation type.
   */
  public function getType(): string;

  /**
   * Get the organisation status.
   *
   * @return string
   *   The organisation status.
   */
  public function getStatus(): string;

  /**
   * Get the organisation's industry classification.
   *
   * @return array|null
   *   The organisation's industry classification,
   *   An array containing the keys 'codes' & 'system'.
   *   Where 'system' represents one of the established
   *   industry classification systems: SIC, NACE, NAICS.
   */
  public function getClassification(): array|null;

  /**
   * Get the raw data array as passed created by the calling plugin.
   *
   * @return array
   *   The raw data containing additional organisation information.
   */
  public function getData(): array;

}
